program UseRes;

uses
  System.Drawing,
  System.Resources,
  System.Collections,
  System.Windows.Forms;

type
  { .NET to VCL mapping }
  TForm   = System.Windows.Forms.Form;
  TBitmap = System.Drawing.Bitmap;
  TIcon   = System.Drawing.Icon;
  TCursor = System.Windows.Forms.Cursor;

type
  { Application main form }
  [STAThread]
  TMainForm = class(TForm)
  private
    ResTbl: HashTable;
    SplashBitmap: Bitmap;
    procedure InitComponents;
  protected
    procedure PaintHandler(Sender: TObject; pe: PaintEventArgs);
    function LoadResource(resFile: string): HashTable;
  public
    constructor Create(Owner: TObject);
  end;

{ TMainForm }

constructor TMainForm.Create(Owner: TObject);
begin
  inherited Create;
  InitComponents;
end;

procedure TMainForm.InitComponents;
begin
  SuspendLayout;
  ResTbl:= LoadResource('MyRes.resources');

  Text:= 'Using Resources';

  SplashBitmap:= TBitmap(ResTbl['SPLASH']);
  Icon:= TIcon(ResTbl['MAINICON']);
  Cursor:= TCursor(ResTbl['MAINCURSOR']);

  AutoScaleBaseSize:= Size.Create(5, 13);
  ClientSize:= Size.Create(750, 500);
  add_Paint(PaintHandler);
  ResumeLayout(False);
end;

function TMainForm.LoadResource(resFile: string): HashTable;
var
  rr: ResourceReader;
  resTbl: Hashtable;
  de: IDictionaryEnumerator;
begin
  try
    resTbl:= Hashtable.Create;
    rr:= ResourceReader.Create(resFile);
    de:= IDictionaryEnumerator(rr.GetEnumerator);

    while IEnumerator(de).MoveNext do
      resTbl.Add(de.Key,de.Value);

    rr.Close;
    Result:= resTbl;
  except
    on Exception do
      Result:= nil;
  end;
end;

procedure TMainForm.PaintHandler(Sender: TObject; pe: PaintEventArgs);
begin
  pe.Graphics.FillRectangle(SolidBrush.Create(Color.White), ClientRectangle);
  pe.Graphics.DrawImage(SplashBitmap, 50, 50, 450, 350);
end;

begin
  Application.Run(TMainForm.Create(nil));
end.
